Checklist MDR Annex II: Technical Documentation

| **#**                                                        | **Requirement**                                              | **Applicable? (yes/no)** | **Justification (if not  applicable)** | **Reference/Proof of  conformity** |
| ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------ | -------------------------------------- | ---------------------------------- |
|                                                              | The technical documentation  and, if applicable, the summary thereof to be drawn up by the manufacturer  shall be presented in a clear, organised, readily searchable and unambiguous  manner and shall include in particular the elements listed in this Annex. |                          |                                        |                                    |
| 1.   DEVICE  DESCRIPTION AND SPECIFICATION, INCLUDING VARIANTS AND ACCESSORIES |                                                              |                          |                                        |                                    |
| 1.1.                                                         | Device description and  specification                        | n/a                      | n/a                                    | n/a                                |
|                                                              | (a) product or trade name  and a general description of the device including its intended purpose and  intended users; |                          |                                        |                                    |
|                                                              | (b) the Basic UDI-DI as  referred to in Part C of Annex VI assigned by the manufacturer to the device  in question, as soon as identification of this device becomes based on a UDI  system, or otherwise a clear identification by means of product code, catalogue  number or other unambiguous reference allowing traceability; |                          |                                        |                                    |
|                                                              | (c) the intended patient  population and medical conditions to be diagnosed, treated and/or monitored  and other considerations such as patient selection criteria, indications,  contra-indications, warnings; |                          |                                        |                                    |
|                                                              | (d) principles of operation  of the device and its mode of action, scientifically demonstrated if  necessary; |                          |                                        |                                    |
|                                                              | (e) the rationale for the  qualification of the product as a device; |                          |                                        |                                    |
|                                                              | (f) the risk class of the  device and the justification for the classification rule(s) applied in  accordance with Annex VIII; |                          |                                        |                                    |
|                                                              | (g) an explanation of any  novel features;                   |                          |                                        |                                    |
|                                                              | (h) a description of the  accessories for a device, other devices and other products that are not  devices, which are intended to be used in combination with it; |                          |                                        |                                    |
|                                                              | (i) a description or  complete list of the various configurations/variants of the device that are  intended to be made available on the market; |                          |                                        |                                    |
|                                                              | (j) a general description of  the key functional elements, e.g. its parts/components (including software if  appropriate), its formulation, its composition, its functionality and, where  relevant, its qualitative and quantitative composition. Where appropriate,  this shall include labelled pictorial representations (e.g. diagrams,  photographs, and drawings), clearly indicating key parts/components,  including sufficient explanation to understand the drawings and diagrams; |                          |                                        |                                    |
|                                                              | (k) a description of the raw  materials incorporated into key functional elements and those making either  direct contact with the human body or indirect contact with the body, e.g.,  during extracorporeal circulation of body fluids; |                          |                                        |                                    |
|                                                              | (l) technical  specifications, such as features, dimensions and performance attributes, of  the device and any variants/configurations and accessories that would  typically appear in the product specification made available to the user, for  example in brochures, catalogues and similar publications. |                          |                                        |                                    |
| 1.2.                                                         | Reference to previous and  similar generations of the device | n/a                      | n/a                                    | n/a                                |
|                                                              | (a) an overview of the  previous generation or generations of the device produced by the  manufacturer, where such devices exist; |                          |                                        |                                    |
|                                                              | (b) an overview of  identified similar devices available on the Union or international markets,  where such devices exist. |                          |                                        |                                    |
| 2.   INFORMATION  TO BE SUPPLIED BY THE MANUFACTURER         |                                                              |                          |                                        |                                    |
|                                                              | A complete set of:  ·     the label or labels on the device and on its  packaging, such as single unit packaging, sales packaging, transport  packaging in case of specific management conditions, in the languages  accepted in the Member States where the device is envisaged to be sold; and  ·     the instructions for use in the languages  accepted in the Member States where the device is envisaged to be sold. |                          |                                        |                                    |
| 3.   DESIGN  AND MANUFACTURING INFORMATION                   |                                                              |                          |                                        |                                    |
|                                                              | (a) information to allow the  design stages applied to the device to be understood; |                          |                                        |                                    |
|                                                              | (b) complete information and  specifications, including the manufacturing processes and their validation,  their adjuvants, the continuous monitoring and the final product testing.  Data shall be fully included in the technical documentation; |                          |                                        |                                    |
|                                                              | (c) identification of all  sites, including suppliers and sub-contractors, where design and  manufacturing activities are performed. |                          |                                        |                                    |
| 4.   GENERAL  SAFETY AND PERFORMANCE REQUIREMENTS            |                                                              |                          |                                        |                                    |
|                                                              | The documentation shall  contain information for the demonstration of conformity with the general  safety and performance requirements set out in Annex I that are applicable to  the device taking into account its intended purpose, and shall include a  justification, validation and verification of the solutions adopted to meet  those requirements. The demonstration of conformity shall include: | n/a                      | n/a                                    | n/a                                |
|                                                              | (a) the general safety and  performance requirements that apply to the device and an explanation as to  why others do not apply; |                          |                                        |                                    |
|                                                              | (b) the method or methods  used to demonstrate conformity with each applicable general safety and  performance requirement; |                          |                                        |                                    |
|                                                              | (c) the harmonised  standards, CS or other solutions applied; and |                          |                                        |                                    |
|                                                              | (d) the precise identity of  the controlled documents offering evidence of conformity with each harmonised  standard, CS or other method applied to demonstrate conformity with the  general safety and performance requirements. The information referred to under  this point shall incorporate a cross-reference to the location of such  evidence within the full technical documentation and, if applicable, the  summary technical documentation. |                          |                                        |                                    |
| 5.   BENEFIT-RISK  ANALYSIS AND RISK MANAGEMENT              |                                                              |                          |                                        |                                    |
|                                                              | The documentation shall  contain information on:             | n/a                      | n/a                                    | n/a                                |
|                                                              | (a) the benefit-risk  analysis referred to in Sections 1 and 8 of Annex I, and |                          |                                        |                                    |
|                                                              | (b) the solutions adopted  and the results of the risk management referred to in Section 3 of Annex I. |                          |                                        |                                    |
| 6.   PRODUCT  VERIFICATION AND VALIDATION                    |                                                              |                          |                                        |                                    |
|                                                              | The documentation shall  contain the results and critical analyses of all verifications and validation  tests and/or studies undertaken to demonstrate conformity of the device with  the requirements of this Regulation and in particular the applicable general  safety and performance requirements. |                          |                                        |                                    |
| 6.1.                                                         | Pre-clinical and clinical  data                              | n/a                      | n/a                                    | n/a                                |
|                                                              | (a) results of tests, such  as engineering, laboratory, simulated use and animal tests, and evaluation of  published literature applicable to the device, taking into account its  intended purpose, or to similar devices, regarding the pre-clinical safety of  the device and its conformity with the specifications; |                          |                                        |                                    |
|                                                              | (b) detailed information  regarding test design, complete test or study protocols, methods of data  analysis, in addition to data summaries and test conclusions regarding in  particular:  ·     the biocompatibility of the device including  the identification of all materials in direct or indirect contact with the  patient or user;  ·     physical, chemical and microbiological  characterisation;  ·     electrical safety and electromagnetic  compatibility;  ·     software verification and validation  (describing the software design and development process and evidence of the  validation of the software, as used in the finished device. This information  shall typically include the summary results of all verification, validation  and testing performed both in-house and in a simulated or actual user  environment prior to final release. It shall also address all of the  different hardware configurations and, where applicable, operating systems  identified in the information supplied by the manufacturer);  ·     stability, including shelf life; and  ·     performance and safety. |                          |                                        |                                    |
|                                                              | Where applicable, conformity  with the provisions of Directive 2004/10/EC of the European Parliament and of  the Council (1) shall be demonstrated. |                          |                                        |                                    |
|                                                              | Where no new testing has  been undertaken, the documentation shall incorporate a rationale for that  decision. An example of such a rationale would be that biocompatibility  testing on identical materials was conducted when those materials were  incorporated in a previous version of the device that has been legally placed  on the market or put into service; |                          |                                        |                                    |
|                                                              | (c) the clinical evaluation  report and its updates and the clinical investigation plan referred to in  Article 61(12) and Part A of Annex XIV; |                          |                                        |                                    |
|                                                              | (d) the PMCF plan and PMCF  evaluation report referred to in Part B of Annex XIV or a justification why a  PMCF is not applicable. |                          |                                        |                                    |
| 6.2.                                                         | Additional information  required in specific cases           |                          |                                        |                                    |
|                                                              | (a) Where a device  incorporates, as an integral part, a substance which, if used separately, may  be considered to be a medicinal product within the meaning of point 2 of  Article 1 of Directive 2001/83/EC, including a medicinal product derived from  human blood or human plasma, as referred to in the first subparagraph of  Article 1(8), a statement indicating this fact. In this case, the  documentation shall identify the source of that substance and contain the  data of the tests conducted to assess its safety, quality and usefulness,  taking account of the intended purpose of the device. |                          |                                        |                                    |
|                                                              | (b) Where a device is  manufactured utilising tissues or cells of human or animal origin, or their  derivatives, and is covered by this Regulation in accordance with points (f)  and (g) of Article 1(6), and where a device incorporates, as an integral  part, tissues or cells of human origin or their derivatives that have an  action ancillary to that of the device and is covered by this Regulation in  accordance with the first subparagraph of Article 1(10), a statement  indicating this fact. In such a case, the documentation shall identify all  materials of human or animal origin used and provide detailed information  concerning the conformity with Sections 13.1. or 13.2., respectively, of  Annex I. |                          |                                        |                                    |
|                                                              | (c) In the case of devices  that are composed of substances or combinations of substances that are  intended to be introduced into the human body and that are absorbed by or  locally dispersed in the human body, detailed information, including test  design, complete test or study protocols, methods of data analysis, and data  summaries and test conclusions, regarding studies in relation to:  ·     absorption, distribution, metabolism and  excretion;  ·     possible interactions of those substances, or  of their products of metabolism in the human body, with other devices,  medicinal products or other substances, considering the target population,  and its associated medical conditions;  ·     local tolerance; and  ·     toxicity, including single-dose toxicity,  repeat-dose toxicity, genotoxicity, carcinogenicity and reproductive and  developmental toxicity, as applicable depending on the level and nature of  exposure to the device. |                          |                                        |                                    |
|                                                              | In the absence of such  studies, a justification shall be provided. |                          |                                        |                                    |
|                                                              | (d) In the case of devices  containing CMR or endocrine-disrupting substances referred to in Section  10.4.1 of Annex I, the justification referred to in Section 10.4.2 of that  Annex. |                          |                                        |                                    |
|                                                              | (e) In the case of devices  placed on the market in a sterile or defined microbiological condition, a  description of the environmental conditions for the relevant manufacturing  steps. In the case of devices placed on the market in a sterile condition, a  description of the methods used, including the validation reports, with  respect to packaging, sterilisation and maintenance of sterility. The  validation report shall address bioburden testing, pyrogen testing and, if  applicable, testing for sterilant residues. |                          |                                        |                                    |
|                                                              | (f) In the case of devices  placed on the market with a measuring function, a description of the methods  used in order to ensure the accuracy as given in the specifications. |                          |                                        |                                    |
|                                                              | (g) If the device is to be  connected to other device(s) in order to operate as intended, a description  of this combination/configuration including proof that it conforms to the  general safety and performance requirements when connected to any such device(s)  having regard to the characteristics specified by the manufacturer. |                          |                                        |                                    |
|                                                              | (1) Directive 2004/10/EC of  the European Parliament and of the Council of 11 February 2004 on the  harmonisation of laws, regulations and administrative provisions relating to  the application of the principles of good laboratory practice and the  verification of their applications for tests on chemical substances (OJ L 50,  20.2.2004, p. 44). |                          |                                        |                                    |